<?php
/**
 * Open Source Social Network
 *
 * @package   Open Source Social Network (OSSN)
 * @author    OSSN Core Team <info@openteknik.com>
 * @copyright (C) OpenTeknik LLC
 * @license   Open Source Social Network License (OSSN LICENSE)  http://www.opensource-socialnetwork.org/licence
 * @link      https://www.opensource-socialnetwork.org/
 */

$ja = array(
	'home' => 'Home',
	'site:index' => 'Welcome',
	'news:feed' => 'News Feed',
	'new:feed' => 'News Feed',
	'photos:ossn' => '写真',
	'admin:view:site' => 'サイトを見る',
	
	'home:top:heading' => "Welcome to %s! 今すぐ参加して、新しい友達を作り、グループを作成し、写真を追加してください。",
	'create:account' => 'アカウントを作成する',
	'its:free' => "無料で、いつでも利用できます。",
		
	'copyright' => '&copy; COPYRIGHT',
	'powered' => 'Powered by the Open Source Social Network.',
	
	'name' => '名前',
	'birthdate' => '誕生日',
	'first:name' => '名前',
	'last:name' => '苗字',
	'email' => '電子メール',
	'email:again' => '電子メールを確認',
	'username' => 'ユーザー名',
	'password' => 'パスワード',
	'day' => '日',
	'month' => '月',
	'year' => '年',
	'male' => '男性',
	'female' => '女性',
	'account:create:notice' => '[アカウントを作成]をクリックすると、',
	'gender' => '性別',
	
	'account:settings' => 'アカウント設定',
	'page:error' => 'ページがみつかりませんでした!',
	'page:error:text' => 'リクエストしたページは利用できないか、削除された可能性があります。',
	'page:error:heading' => '404',
	
	'search:users' => '人',
	'admin:logout' => 'ログアウト',
	'logout' => 'ログアウト',
	
	'ossn:like:this' => '%s がいいね！と言っています',
	'ossn:like:you:and:this' => 'You and %s liked this',
	'ossn:like:people' => '%s People',
	'ossn:like:person' => '%s Person',
	'ossn:liked:you' => 'あなたがいいね！しました',
	'ossn:unlike' => 'いいね！を取り消す',
	'ossn:like' => 'いいね！',
	
	'admin:components' => '構成部品',
	'admin:dashboard' => 'ダッシュボード',
	'admin:install' => 'インストーラー',
	'admin:themes' => 'テーマ',
	'admin:basic' => 'ベーシック',
	'admin:cache' => 'キャッシュ',
	'admin:mode' => 'モード',
	'configure' => '構成、設定',
	'admin:help' => 'ヘルプ',
	'admin:support' => 'サポート',
	
	'ossn:update:check:error' => 'エラー',
	
	'upload' => 'アップロード',
	'save' => '保存',
	'add' => '追加',
	'edit' => '編集',
	'search' => '検索',
	'delete' => '削除',
	
	'admin:users' => 'ユーザーのリスト',
	'admin:add:user' => 'ユーザーを追加',
	'admin:user:deleted' => 'ユーザーが削除されました！',
	'admin:user:delete:error' => 'ユーザーを削除できません。 後でもう一度やり直してください。',
	
	'type' => 'タイプ',
	'normal' => '普通',
	'admin' => '管理者',
	
	'lastlogin' => '最終ログイン',
	
	'my:version' => 'My OSSN Version',
	'online:users' => 'オンラインユーザー',
	'themes' => 'テーマ',
	'users' => 'ユーザー',
	'components' => '構成部品',
	'available:updates' => '利用可能なアップデート',
	'website:name' => 'サイトの名前',
	'owner:email' => 'オーナーのメールアドレス',
	'default:lang' => 'デフォルト言語',
	
	'timeline' => 'タイムライン',
	'photos' => '写真',
	'friends' => '友達',
	'links' => 'リンク',
	'ossn:add:user:mail:subject' => "%s please confirm your email address for %s!",
	'ossn:add:user:mail:body' => "％sの使用を開始する前に、メールアドレスを確認する必要があります。

以下のリンクをクリックして、メールアドレスを確認してください。

%s

リンクが機能しない場合は、アドレスを手動でコピーしてブラウザに貼り付けることができます。

%s",
	'user:friends' => '友達',
	'user:account:validated' => 'アカウントが正常に検証されました！',
	'user:account:validate:fail' => 'アカウントを検証できません！ 後でもう一度やり直してください。',
	
	'cache:enabled' => 'キャッシュが有効になりました！',
	'cache:disabled' => 'キャッシュが無効になりました！',
	'cache:enable' => 'キャッシュを有効にする',
	'cache:disable' => 'キャッシュを無効にする',
    'com:pref' => 'このコンポーネントの設定を保持しますか？ コンポーネントを更新する場合は、設定を維持することをお勧めします。 OKを押して保持します。 キャンセルを押して設定を削除します。',
	
	'cache:1' => '有効',
	'cache:0' => '無効',
	'cache:notice' => 'サイトのパフォーマンスを向上させるために、CSSおよびJavascriptファイルをキャッシュに保存します。',
	
	'theme:install:notice' => '有効な.zipテーマパッケージをアップロードします。',
	'com:install:notice' => '有効な.zipコンポーネントパッケージをアップロードします。',
	
	'login:error' => 'ユーザー名かパスワードが無効です',
	'login:error:sub' => "ログインできませんでした。ユーザー名またはパスワードを確認して、もう一度お試しください。",
	'login:success' => 'これでログインできました！',
	'com:installed' => 'コンポーネントがコンポーネントリストにアップロードされました。コンポーネントページから有効にできます。',
	'com:install:error' => 'コンポーネントをアップロードできません。有効なパッケージであることを確認してください。',
	'settings:saved' => '設定が保存されました',
	'com:deleted' => 'コンポーネントが削除されました！',
	'com:delete:error' => 'コンポーネントを削除できません！ 後でもう一度やり直してください。',
	'com:disabled' => '無効になりました！',
	'com:enabled' => 'コンポーネントが有効になりました！',
	
	'theme:delete:active' => 'アクティブなテーマを削除できません。',
	'theme:deleted' => 'テーマを削除しました',
	'theme:delete:error' => 'テーマを削除できません！ 後でもう一度やり直してください。',
	'theme:enabled' => 'テーマを有効にしました',
	'theme:installed' => 'テーマが正常にインストールされました！',
	'theme:install:error' => 'テーマをインストールできません。 使用しているOSSNバージョンと互換性があることを確認してください。',
	
	'fields:require' => '全て必須項目です！',
	'username:error' => 'ユーザー名が正しくありません。半角英数字で入力してください。スペースや特殊文字は使用しないでください。A-Zのアルファベットと0-9の数字のみ使用できます。ユーザー名は5文字以上でなければなりません。',
	'password:error' => 'パスワードは5文字以上にする必要があります。',
	'account:created' => 'アカウントを作成しました。',
	'account:create:error:admin' => 'アカウントの登録に失敗しました！ 後でもう一度やり直してください。',
	'user:updated' => 'ユーザーが更新されました！',
	'logged:out' => 'あなたはログアウトしました！',
	'username:inuse' => '次のユーザー名は既に使用されています。 別のユーザー名を選択してください。',
	'email:inuse' => '使用したメールアドレスは既にデータベースに存在します。 別のメールアドレスを試してください。',
	'email:invalid' => 'メールアドレスが無効です！ 入力したメールアドレスが正しいことを確認してください。',
	'email:error:matching' => "メールアドレスが一致しません。",
	'account:created:email' => "アカウントが登録されました！ アカウントの有効化メールを送信しました。 メールが届かない場合は、迷惑メール/ゴミ箱を確認してください",
	
	'administration' => '管理',
	
	'privacy' => 'プライバシー',
	'close' => '非公開',
	'open' => '公開',
	'public' => 'パブリック',
	'friends' => '友達',
	'privacy:public:note' => 'このサイトの全員がこれを見ることができます。',
	'privacy:friends:note' => 'あなたの友達だけがこれを見ることができます。',
	
	'add:friend' => '友達を追加',
	'cancel:request' => 'リクエストをキャンセル',
	'remove:friend' => '友達を外す',
	'no:friends' => '友達がいません。代わりに私が友達になってあげましょうか。By Admin',
	'settings' => '設定',
	'ossn:add:friend:error' => '友達を追加できません。',
	'ossn:friend:request:submitted' => '友達リクエストが送信されました！',
	
	/* Upgrades */
	'upgrade:file:load:error' => 'アップグレードファイルを読み込めません！',
	'upgrade:success' => "ウェブサイトは正常にアップグレードされ、%sがリリースされました。",
	'upgrade:failed' => "サイトをアップグレードして%sをリリースできません。",
	'upgrade:not:available' => 'アップグレードするものはありません！',
	
	'site:login' => 'ログイン',
	/* Page errors */
	'system:error:title' => '何かがうまくいきませんでした！',
	'system:error:text' => '何かがうまくいきませんでした！ このページをリロードして、もう一度試してください。',
	
	/* Password Reset */
	'reset:login' => 'パスワードをリセット',
	'reset:password' => 'あなたのパスワードをリセットする',
	'enter:new:password' => '以下に新しいパスワードを入力し、リセットをクリックします。次からは、ちゃんと覚えておくんだよ。 By Admin',
	'reset' => 'Reset',
	'enter:emai:reset:pwd' => 'パスワードをリセットするには、アカウントのメールアドレスを入力してください。',
	'ossn:reset:password:subject' => 'あなたのパスワードをリセット',
	'ossn:reset:password:body' => "こんにちは %s さん,
	
以下のリンクをクリックしてパスワードをリセットするか、リンクをコピーしてブラウザのアドレスバーに貼り付けてください。

%s

%s",
	'passord:reset:success' => 'パスワードが正常に変更されました！',
	'passord:reset:fail' => 'パスワードがリセットできませんでした。後でもう一度お試しください。',
	'password:reset:email:required' => 'メールを空にすることはできません！',
	'passord:reset:email:success' => 'パスワードのリセット手順がメールアドレスに送信されました。',
	
	'erros:reporting' => 'エラー報告',
	'erros:off' => 'Off',
	'erros:on' => 'On',
	'basic:settings' => '基本設定',
	
	'ossn:new:version:error' => 'Unknown',
	'ossn:version:avaialbe' => "%s",
	
	'ossn:exception:title' => 'システムエラーが発生しました。 後でもう一度やり直してください。 このエラーの詳細を%sのシステム管理者にメールで送信できます。',
	'ossn:securitytoken:failed' => '要求したアクションは無効です。',
	'ossn:component:delete:exception' => 'このコンポーネントを削除してもよろしいですか？',
	'ossn:user:delete:exception' => 'このユーザーを削除してもよろしいですか？',
	
	//access
	'title:access:1' => 'プライベート',
	'title:access:2' => 'パブリック',
	'title:access:3' => '友達',
	
	'upload:file:error:ini_size' => 'アップロードしようとしたファイルが大きすぎます。',
	'upload:file:error:form_size' => 'アップロードしようとしたファイルが大きすぎます。',
	'upload:file:error:partial' => 'ファイルのアップロードが完了しませんでした。',
	'upload:file:error:no_file' => 'ファイルが選択されていません。',
	'upload:file:error:no_tmp_dir' => 'アップロードされたファイルを保存できません。',
	'upload:file:error:cant_write' => 'アップロードされたファイルを保存できません。',
	'upload:file:error:extension' => 'アップロードされたファイルを保存できません。',
	'upload:file:error:unknown' => 'ファイルのアップロードに失敗しました。',
	'upload:file:error:multiple' => '%s回のアップロードのうち%s回が失敗しました。',
	
	'ossn:post:size:exceed' => '要求したアクションがサイズ制限を超えています。',
	
	'admin:com:installer' => 'コンポーネントインストーラー',
	'admin:theme:installer' => 'テーマインストーラー',
	'admin:cache:settings' => 'キャッシュ設定',
	'admin:user:list' => 'ユーザー一覧',
	'admin:edit:user' => 'ユーザーを編集',
	'admin:login' => 'ログイン',
	'admin:notification:email' => 'サイト通知メール',
	'admin:email:name' => '通知メール名',
	'notification_email' => 'Notification Email (noreply@domain.com)',
	'owner_email' => 'Owner Email (mysite@domain.com)',
	'ossn:websitename' => 'あなたのウェブサイトのメール',
	'ossn:user:validation:resend' => 'あなたのアカウントは検証されていません！ ログインする前にアカウントを確認する必要があります。別の確認メールがメールアドレスに送信されました。',
	'site:timepassed:text' => '%s ago',
	// localization of passed time: 16 time elements (even = singular / odd = plural)
	'site:timepassed:data' => 'second|seconds|minute|minutes|hour|hours|day|days|week|weeks|month|months|year|years|decade|decades',
	'ossn:notification:no:notification' => '表示するデータはありません。',
	'admin:button:enable' => '有効にする',
	'admin:button:enabled' => '有効化',
	'admin:button:disable' => '無効にする',
	'admin:button:configure' => '構成、設定',
	'admin:button:delete' => '削除',
	'admin:component:author' => '著者',
	'admin:component:website' => 'ウェブサイト',
	'admin:sidemenu:components' => 'コンポーネント',
	'admin:sidemenu:themes' => 'テーマ',
	'admin:sidemenu:settings' => 'サイトの設定',
	'admin:sidemenu:usermanager' => 'ユーザーマネージャー',
	'cancel' => 'Cancel',
	'ossn:language:complete' => 'コンプリート',
	'ossn:pagination:first' => '最初',
	'ossn:pagination:last' => '最後',
	'validate' => 'Validate',
	'admin:users:unvalidated' => '未検証のユーザー',
	'admin:user:validated' => 'ユーザー検証済み',
	'admin:user:validate:error' => 'ユーザーを検証できませんでした。',
	
	//v3.0
	//admin
	'my:files:version' => 'Ossnのバージョン',
	'cache:flush:error' => 'キャッシュをフラッシュできません。キャッシュ設定でキャッシュが有効になっていることを確認してください',
	'cache:flushed' => 'キャッシュをフラッシュしました。',
	'ossn:version' => 'OSSN version', 
	'php:extension' => 'PHP extension',
	'php:version' => 'PHP version',
	'php:function' => 'PHP function',
	'admin:old:com' => "Your ossn_com.xml file is based on old version of Ossn. Please update '%s' component.",
	'admin:old:theme' => "Your ossn_theme.xml file is based on old version of Ossn. Please update '%s' theme.",
	'admin:button:disabled' => 'Disabled',
	'admin:flush:cache' => 'Flush Cache',
	'admin:com:version' => 'Version',
	'admin:com:author' => 'Author',
	'admin:com:author:url' => 'Author URL',
	'admin:com:license' => 'License',
	'admin:com:requirements' => 'Requirements',
	'admin:com:requirement' => '要件',
	'admin:com:fulfilled' => '充実した',
	'admin:com:used:by' => 'によって使われた',
	'ossn:exception:make:sure' => 'Are you sure?',
	'ossn:premium' => 'Premium Version',
	'datepicker:days' => "Su, Mo, Tu, We, Th, Fr, Sa",
	'datepicker:months' => "Jan., Feb., Mar., Apr., May, June, July, Aug., Sep., Oct., Nov., Dec.",
	//v5.3
	'male:gendercolor' => '#01ADEF',
	'female:gendercolor' => '#ED008C',
	'ossn:admin:settings:off' => 'disabled',
	'ossn:admin:settings:on' => 'enabled',
	'ossn:admin:settings:saved' => 'Settings saved!',
	'ossn:admin:settings:save:error' => 'Cannot save settings! Please check your error_log file.',	
	
	'ossn:com:installer:create:tmpdir:error' => 'Cannot create temporary data directory', 
	'ossn:com:installer:upload:error' => 'An error occured during upload: %s',
	'ossn:com:installer:version:error' => 'This component requires Ossn %s or higher',
	'ossn:com:installer:remove:comdir:error' => 'This component has been installed already - please delete it from the list on the components page, first',
	'ossn:com:installer:create:comdir:error' => 'Cannot copy files to component directory',
	'ossn:com:installer:xml:incomplete:error' => 'Component description file missing or incomplete',
	'ossn:com:installer:zip:incomplete:error' => 'Component zip-archive incomplete',
	'ossn:com:installer:open:zip:error' => 'Cannot open component zip-archive',
	'ossn:com:installer:move:uploaded:file:error' => 'Invalid zip-archive',
	'ossn:com:installer:com:installation:success' => 'Component has been uploaded to your components list, you can now enable it from components page.',

	'ossn:theme:installer:create:tmpdir:error' => '一時的なデータディレクトリを作成できない', 
	'ossn:theme:installer:upload:error' => 'アップロード中にエラーが発生しました。%s',
	'ossn:theme:installer:version:error' => 'このテーマには Ossn %s 以上が必要です。',
	'ossn:theme:installer:remove:themedir:error' => 'このテーマはすでにインストールされています - テーマページのリストから削除してください。',
	'ossn:theme:installer:create:themedir:error' => 'テーマディレクトリにファイルをコピーできない',
	'ossn:theme:installer:xml:incomplete:error' => 'テーマの説明ファイルがない、または不完全',
	'ossn:theme:installer:zip:incomplete:error' => 'テーマの zip-archive 不完全',
	'ossn:theme:installer:open:zip:error' => 'テーマのz ip-archiveが 開けない',
	'ossn:theme:installer:move:uploaded:file:error' => '無効 zip-archive',
	'ossn:theme:installer:theme:installation:success' => 'テーマがテーマリストにアップロードされました。',
	

	'php:upload_err_ok' => 'There is no error, the file uploaded with success',
	'php:upload_err_ini_size' => 'The uploaded file exceeds the upload_max_filesize directive in php.ini',
	'php:upload_err_form_size' => 'The uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the HTML form',
	'php:upload_err_partial' => 'The uploaded file was only partially uploaded',
	'php:upload_err_no_file' => 'No file was uploaded',
	'php:upload_err_no_tmp_dir' => 'Missing a temporary folder',
	'php:upload_err_cant_write' => 'Failed to write file to disk',
	'php:upload_err_extension' => 'A PHP extension stopped the file upload',	
	'php:extension:notfound' => 'PHP 拡張が見つかりません。', 
	
	'admin:basiccache' => '基本キャッシュ', 
	'admin:dcache:note' => '動的データは、動的キャッシュを使用してキャッシュされます。 これは、アプリケーションの処理を迅速化することができます。 キャッシュを使用可能にすると、アプリケーションの実行速度が向上するだけでなく、キャッシュ・サーバーの接続が遅くなる場合には役立ちません。  キャッシュ・サーバーは、ソーシャル・ネットワークと同じホスト上にセットアップすることをお勧めします。 共有ホスティング・サービスによるキャッシュの使用はご遠慮ください。 一度に 1 つのキャッシュ・システムしか使用できません。', 
	'admin:dcache:cachename' => 'キャッシュサーバーのタイプ', 
	'admin:dcache:extension:enabled' => '拡張が有効', 
	'admin:dcache:select:server:type' => 'サーバータイプの選択', 
	'admin:dcache:host' => 'ホスト', 
	'admin:dcache:port' => 'ポート', 
	'admin:dcache:username' => 'ユーザー名 ( 存在する場合 )', 
	'admin:dcache:password' => 'パスワード ( 存在する場合 )', 
	'admin:dcache:setstatus' => '状況の設定', 
	'admin:dcache:extension:tests' => 'テスト', 
	'admin:dcache:errorconnection' => '指定の詳細を使用して接続を確認できません', 
	'admin:dcache:required:field' => '必須フィールドに入力してください', 
	'admin:dcache:memcached:authnotsupport' => 'Memcached php の拡張機能は認証をサポートしていません。', 	
	/*
	 * List of ISO 639-1 language codes
	 * http://en.wikipedia.org/wiki/List_of_ISO_639-1_codes
	 */
	"aa" => "Afar",
	"ab" => "Abkhazian",
	"af" => "Afrikaans",
	"am" => "Amharic",
	"ar" => "Arabic",
	"as" => "Assamese",
	"ay" => "Aymara",
	"az" => "Azerbaijani",
	"ba" => "Bashkir",
	"be" => "Byelorussian",
	"bg" => "Bulgarian",
	"bh" => "Bihari",
	"bi" => "Bislama",
	"bn" => "Bengali; Bangla",
	"bo" => "Tibetan",
	"br" => "Breton",
	"ca" => "Catalan",
	"co" => "Corsican",
	"cs" => "Czech",
	"cy" => "Welsh",
	"da" => "Danish",
	"de" => "German",
	"dz" => "Bhutani",
	"el" => "Greek",
	"en" => "English",
	"eo" => "Esperanto",
	"es" => "Spanish",
	"et" => "Estonian",
	"eu" => "Basque",
	"fa" => "Persian",
	"fi" => "Finnish",
	"fj" => "Fiji",
	"fo" => "Faeroese",
	"fr" => "French",
	"fy" => "Frisian",
	"ga" => "Irish",
	"gd" => "Scots / Gaelic",
	"gl" => "Galician",
	"gn" => "Guarani",
	"gu" => "Gujarati",
	"he" => "Hebrew",
	"ha" => "Hausa",
	"hi" => "Hindi",
	"hr" => "Croatian",
	"hu" => "Hungarian",
	"hy" => "Armenian",
	"ia" => "Interlingua",
	"id" => "Indonesian",
	"ie" => "Interlingue",
	"ik" => "Inupiak",
	"is" => "Icelandic",
	"it" => "Italian",
	"iu" => "Inuktitut",
	"iw" => "Hebrew (obsolete)",
	"ja" => "日本語",
	"ji" => "Yiddish (obsolete)",
	"jw" => "Javanese",
	"ka" => "Georgian",
	"kk" => "Kazakh",
	"kl" => "Greenlandic",
	"km" => "Cambodian",
	"kn" => "Kannada",
	"ko" => "Korean",
	"ks" => "Kashmiri",
	"ku" => "Kurdish",
	"ky" => "Kirghiz",
	"la" => "Latin",
	"ln" => "Lingala",
	"lo" => "Laothian",
	"lt" => "Lithuanian",
	"lv" => "Latvian/Lettish",
	"mg" => "Malagasy",
	"mi" => "Maori",
	"mk" => "Macedonian",
	"ml" => "Malayalam",
	"mn" => "Mongolian",
	"mo" => "Moldavian",
	"mr" => "Marathi",
	"ms" => "Malay",
	"mt" => "Maltese",
	"my" => "Burmese",
	"na" => "Nauru",
	"ne" => "Nepali",
	"nl" => "Dutch",
	"no" => "Norwegian",
	"oc" => "Occitan",
	"om" => "(Afan) Oromo",
	"or" => "Oriya",
	"pa" => "Punjabi",
	"pl" => "Polish",
	"ps" => "Pashto / Pushto",
	"pt" => "Portuguese",
	"qu" => "Quechua",
	"rm" => "Rhaeto-Romance",
	"rn" => "Kirundi",
	"ro" => "Romanian",
	"ru" => "Russian",
	"rw" => "Kinyarwanda",
	"sa" => "Sanskrit",
	"sd" => "Sindhi",
	"sg" => "Sangro",
	"sh" => "Serbo-Croatian",
	"si" => "Singhalese",
	"sk" => "Slovak",
	"sl" => "Slovenian",
	"sm" => "Samoan",
	"sn" => "Shona",
	"so" => "Somali",
	"sq" => "Albanian",
	"sr" => "Serbian",
	"ss" => "Siswati",
	"st" => "Sesotho",
	"su" => "Sundanese",
	"sv" => "Swedish",
	"sw" => "Swahili",
	"ta" => "Tamil",
	"te" => "Tegulu",
	"tg" => "Tajik",
	"th" => "Thai",
	"ti" => "Tigrinya",
	"tk" => "Turkmen",
	"tl" => "Tagalog",
	"tn" => "Setswana",
	"to" => "Tonga",
	"tr" => "Turkish",
	"ts" => "Tsonga",
	"tt" => "Tatar",
	"tw" => "Twi",
	"ug" => "Uigur",
	"uk" => "Ukrainian",
	"ur" => "Urdu",
	"uz" => "Uzbek",
	"vi" => "Vietnamese",
	"vo" => "Volapuk",
	"wo" => "Wolof",
	"xh" => "Xhosa",
	"yi" => "Yiddish",
	"yo" => "Yoruba",
	"za" => "Zuang",
	"zh" => "Chinese",
	"zu" => "Zulu"
);
ossn_register_languages('ja', $ja);
